<?php
/**
 * Template Name: L'histoire des 100 pièges
 */
// File Security Check
if (!defined('ABSPATH')) {
    exit;
}

//$config = Presscore_Config::get_instance();
//$config->base_init();

get_header();
?>

<!-- Content -->
<div id="content" class="content" role="main">

    <div class="container-fluid">
        <div class="row piege-bg-blue">
            <div class="col-xs-12">
                <header>
                    <nav class="clearfix">
                        <a href="/les-100-pieges-de-langlais/" class="pull-left">< <?php _e('Retour'); ?></a>
                        <a href="<?php the_field('pieges_lien_commencerr'); ?>" class="pull-right"><?php _e('Commencer'); ?> ></a>
                    </nav>
                    <h1><?php the_title(); ?></h1>
                    <img width="300" height="300" src="<?php echo get_stylesheet_directory_uri(); ?>/images/pieges-100/logo-100-pieges.svg" class="img-responsive" alt="Les 100 pièges de l'anglais" />
                </header>
            </div>
        </div>
        <div class="row" style="background-color: #f2f2f2;">
            <div class="col-xs-12">
                <main>
                    <ul>
                        <?php foreach (get_field('pieges_timeline') as $event) { ?>
                            <li>
                                <div class="visuel">
                                    <?php if ($event['pieges_date']) { ?>
                                        <div class="date">
                                            <span class="ladate"><?php echo $event['pieges_date']; ?></span>
                                        </div>
                                    <?php } ?>
                                    <?php if ($event['pieges_image']) { ?>
                                        <div class="image">
                                            <?php echo wp_get_attachment_image($event['pieges_image'], 'full'); ?>
                                        </div>
                                    <?php } ?>
                                </div>
                                <div class="description">
                                    <?php echo apply_filters('wysiwyg_the_content', $event['pieges_event']); ?>
                                </div>
                            </li>
                        <?php } ?>
                        <li class="lien-commencer">
                            <a href="<?php the_field('pieges_lien_commencerr'); ?>" class="button"><?php _e('Commencer'); ?></a>
                        </li>
                    </ul>
                </main>
            </div>
        </div>
    </div>

</div><!-- #content -->

<?php
get_footer();
