<?php
/**
 * The Template for displaying all single posts.
 *
 * @package presscore
 * @since presscore 0.1
 */
// File Security Check
if (!defined('ABSPATH')) {
    exit;
}

//$config = Presscore_Config::get_instance();
//$config->base_init();

get_header();
?>

<?php if (presscore_is_content_visible()): ?>
    <!-- !- Content -->
    <div id="content" class="content" role="main">
        <div class="container-fluid">
            <div class="row">
                <div class="col-xs-12 col-sm-3 pieges-list-wrap">
                    <img src="<?php echo get_stylesheet_directory_uri(); ?>/images/pieges-100/logo-100-pieges-small.svg" alt="Logo 100 pieges de l'anglais" class="logo-small img-responsive" />
                    <ul id="pieges-list">
                        <?php
                        $args = array(
                            'post_type' => 'piege',
                            'title_li' => false,
                            'walker' => new HundredsMistakesWalker(),
                            'post_status' => array('publish', 'future'),
                        );
                        wp_list_pages($args);
                        ?>
                    </ul>
                </div>
                <div class="col-xs-12 col-sm-9 pieges-lecon-wrap">
                    <?php
                    while (have_posts()) : the_post();

                        // Récupere le chapeau de la page parent
                        $parent = wp_get_post_parent_id(get_the_ID());
                        if ($parent != false) {
                            $post = $parent;
                            setup_postdata($post);
                            get_template_part('templates/pieges/piege', 'introduction');
                            wp_reset_postdata();
                        } else {
                            get_template_part('templates/pieges/piege', 'introduction');
                        }

                        // Affichage de la lecon
                        ?>
                        <div class="row piege-title-wrap">
                            <div class="col-xs-12">
                                <header class="piege-title-container arrow_box">
                                    <h1 class="piege-title"><?php the_title(); ?></h1>
                                </header>
                            </div>
                        </div>
                        <?php
                        $activationBloc = get_field('activation_des_blocs');
                        foreach (array('lecon', 'nuances', 'fauxami', 'exercices') as $bloc) {
                            $enabled = true;
                            if ($bloc != 'lecon') {
                                $enabled = in_array($bloc, $activationBloc);
                            }
                            if ($enabled) {
                                ?>
                                <?php get_template_part('templates/pieges/piege', $bloc); ?>
                                <?php
                            }
                        }

                    endwhile; // end of the loop.
                    ?>
                </div>
            </div>
        </div>

    </div><!-- #content .wf-cell -->
<?php endif; // content is visible     ?>

<?php
get_footer();
