<?php

/**
 * Les 100 pièges de l'anglais - DEBUT
 */
if ((current_user_can('edit_pages'))) {

    function slugify($text) {
        // replace non letter or digits by -
        $text = preg_replace('~[^\pL\d]+~u', '-', $text);

        // transliterate
        $text = iconv('utf-8', 'us-ascii//TRANSLIT', $text);

        // remove unwanted characters
        $text = preg_replace('~[^-\w]+~', '', $text);

        // trim
        $text = trim($text, '-');

        // remove duplicate -
        $text = preg_replace('~-+~', '-', $text);

        // lowercase
        $text = strtolower($text);

        if (empty($text)) {
            return 'n-a';
        }

        return $text;
    }

    add_action('init', 'pieges_100_init');

    /**
     * Register a book post type.
     *
     * @link http://codex.wordpress.org/Function_Reference/register_post_type
     */
    function pieges_100_init() {

        $args = array(
            'label' => 'Pièges',
            'description' => __('Les 100 piÃšges de l\'anglais.', LANGUAGE_ZONE),
            'public' => true,
            'publicly_queryable' => true,
            'show_ui' => true,
            'show_in_menu' => true,
            'query_var' => true,
            'rewrite' => array('slug' => 'les-100-pieges-de-langlais'),
            'capability_type' => 'post',
            'has_archive' => true,
            'hierarchical' => true,
            'menu_position' => null,
            'menu_icon' => 'dashicons-editor-spellcheck',
            'supports' => array('title', 'editor', 'author', 'thumbnail', 'page-attributes')
        );

        register_post_type('piege', $args);
    }

    function some_func($query) {
        if (get_query_var('post_type') == 'piege' || basename(get_page_template()) == 'template-histoire-pieges.php') {
            remove_action('presscore_before_main_container', 'presscore_page_title_controller', 16);
            add_filter('presscore_main_container_classes', 'pieges_main_container_class_filter');
//                add_action('wp_enqueue_scripts', 'pieges_enqueue');
        }
    }

    add_action('pre_get_posts', 'some_func');

    function some_func2($query) {
        if (get_query_var('post_type') == 'piege' || basename(get_page_template()) == 'template-histoire-pieges.php') {
            add_action('wp_enqueue_scripts', 'pieges_enqueue');
        }
    }

    function dump($var) {
        echo '<pre>';
        var_dump($var);
        echo '</pre>';
    }

    add_action('wp', 'some_func2');

    function pieges_enqueue() {
        wp_enqueue_style('pieges-fonts', 'https://fonts.googleapis.com/css?family=Roboto|Roboto+Condensed:300,400,700');
        wp_enqueue_style('pieges-bootstrap-css', get_stylesheet_directory_uri() . '/css/bootstrap.min.css');
        wp_enqueue_style('magnific-popup.css', get_stylesheet_directory_uri() . '/css/magnific-popup.css');
        wp_enqueue_style('pieges-css', get_stylesheet_directory_uri() . '/css/pieges-100.css');
        wp_enqueue_script('pieges-bootstrap-js', get_stylesheet_directory_uri() . '/js/bootstrap.min.js', array('jquery'));
        wp_enqueue_script('jquery.magnific-popup.min.js', get_stylesheet_directory_uri() . '/js/jquery.magnific-popup.min.js', array('jquery'));
        wp_enqueue_script('js.cookie.js', get_stylesheet_directory_uri() . '/js/js.cookie.js', array('jquery'));
        wp_enqueue_script('pieges-js', get_stylesheet_directory_uri() . '/js/pieges-100.js', array('jquery'));
    }

    function pieges_main_container_class_filter($classes = array()) {
        $classes[] = 'sidebar-none';
        $classes[] = 'main-piege';
        return $classes;
    }

    function pieges_template_redirect() {
        if (is_singular('piege')) {
            global $post;
            $args = array(
                'post_parent' => $post->ID,
                'post_type' => 'piege',
                'numberposts' => -1,
                'post_status' => 'publish'
            );
            $children = get_children($args);
            if (!empty($children)) {
                // redirect
                $child = get_last_depth_first_child($post);
                wp_redirect(get_permalink($child));
                die;
            } else {
                // no redirect
                return;
            }
        }
    }

    function get_last_depth_first_child($post) {
        $args = array(
            'post_parent' => $post->ID,
            'post_type' => 'any',
            'numberposts' => -1,
            'post_status' => 'publish'
        );
        $children = get_children($args);
        if (!empty($children)) {
            $post = get_last_depth_first_child(end($children));
        }
        return $post;
    }

    add_action('template_redirect', 'pieges_template_redirect');

    if (function_exists('acf_add_options_page')) {

//            acf_add_options_page(array(
//                'page_title' => 'Les 100 piÃšges : ParamÃštres',
//                'menu_title' => 'Les 100 piÃšges : ParamÃštres',
//                'menu_slug' => 'pieges-100-settings',
//                'capability' => 'edit_posts',
//                'redirect' => false
//            ));
        acf_add_options_page(array(
            'page_title' => 'Les 100 pièges : Paramètres',
            'menu_title' => 'Les 100 pièges : Paramètres',
            'menu_slug' => 'pieges-100-settings',
            'capability' => 'edit_posts',
//                'position' => false,
            'redirect' => false,
        ));
    }

    add_filter('wysiwyg_the_content', 'pieges_the_content_filter');

    /**
     * Registers an editor stylesheet for the theme.
     */
    function pieges_theme_add_editor_styles($current_screen) {
        if ('piege' == $current_screen->post_type) {
            add_editor_style('css/pieges-100-wysiwyg.css');
        }
    }

    add_action('current_screen', 'pieges_theme_add_editor_styles');

    /**
     * Add a icon to the beginning of every post page.
     *
     * @uses is_single()
     */
    function pieges_the_content_filter($content) {

        $content = '<div class="wysiwyg">' . apply_filters('the_content', $content) . '</div>';

        // Returns the content.
        return $content;
    }

    $HundredsMistakesWalkerCounter = 0;

    class HundredsMistakesWalker extends Walker_Page {

        public function start_lvl(&$output, $depth = 0, $args = array()) {
            global $HundredsMistakesWalkerCounter;
            if (isset($args['item_spacing']) && 'preserve' === $args['item_spacing']) {
                $t = "\t";
                $n = "\n";
            } else {
                $t = '';
                $n = '';
            }
            $indent = str_repeat($t, $depth);
            $output .= "{$n}{$indent}<ul class='children collapse' id='collapse-{$depth}-{$HundredsMistakesWalkerCounter}'>{$n}";
            $HundredsMistakesWalkerCounter++;
        }

        public function start_el(&$output, $page, $depth = 0, $args = array(), $current_page = 0) {
            global $HundredsMistakesWalkerCounter;
            if (isset($args['item_spacing']) && 'preserve' === $args['item_spacing']) {
                $t = "\t";
                $n = "\n";
            } else {
                $t = '';
                $n = '';
            }
            if ($depth) {
                $indent = str_repeat($t, $depth);
            } else {
                $indent = '';
            }

            $css_class = array('page_item', 'page-item-' . $page->ID);

            $hasChildren = false;
            if (isset($args['pages_with_children'][$page->ID])) {
                $css_class[] = 'page_item_has_children';
                $hasChildren = true;
            }

            if (!empty($current_page)) {
                $_current_page = get_post($current_page);
                if ($_current_page && in_array($page->ID, $_current_page->ancestors)) {
                    $css_class[] = 'current_page_ancestor';
                }
                if ($page->ID == $current_page) {
                    $css_class[] = 'current_page_item';
                } elseif ($_current_page && $page->ID == $_current_page->post_parent) {
                    $css_class[] = 'current_page_parent';
                }
            } elseif ($page->ID == get_option('page_for_posts')) {
                $css_class[] = 'current_page_parent';
            }

            if ($page->post_status != 'publish') {
                $css_class[] = 'future';
            }

            /**
             * Filters the list of CSS classes to include with each page item in the list.
             *
             * @since 2.8.0
             *
             * @see wp_list_pages()
             *
             * @param array   $css_class    An array of CSS classes to be applied
             *                              to each list item.
             * @param WP_Post $page         Page data object.
             * @param int     $depth        Depth of page, used for padding.
             * @param array   $args         An array of arguments.
             * @param int     $current_page ID of the current page.
             */
            $css_classes = implode(' ', apply_filters('page_css_class', $css_class, $page, $depth, $args, $current_page));

            if ('' === $page->post_title) {
                /* translators: %d: ID of a post */
                $page->post_title = sprintf(__('#%d (no title)'), $page->ID);
            }

            $args['link_before'] = empty($args['link_before']) ? '' : $args['link_before'];
            $args['link_after'] = empty($args['link_after']) ? '' : $args['link_after'];

            $atts = array();
            $atts['href'] = $page->post_status == 'publish' ? get_permalink($page->ID) : '#future';
            if ($page->post_status != 'publish') {
                $atts['data-effect'] = "mfp-move-horizontal";
            }

            /**
             * Filters the HTML attributes applied to a page menu item's anchor element.
             *
             * @since 4.8.0
             *
             * @param array $atts {
             *     The HTML attributes applied to the menu item's `<a>` element, empty strings are ignored.
             *
             *     @type string $href The href attribute.
             * }
             * @param WP_Post $page         Page data object.
             * @param int     $depth        Depth of page, used for padding.
             * @param array   $args         An array of arguments.
             * @param int     $current_page ID of the current page.
             */
            $atts = apply_filters('page_menu_link_attributes', $atts, $page, $depth, $args, $current_page);

            /* Bootstrap Collapse */
            $navMore = '';
            if ($hasChildren) {
//                    $atts['data-parent'] = '#pieges-list';
                if ($page->post_status == 'publish') {
                    $atts['data-toggle'] = 'collapse';
                    $atts['href'] = "#collapse-{$depth}-{$HundredsMistakesWalkerCounter}";
                }
                $navMore = '<svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 21.87 21.87" class="nav-more">
    <title>nav-more</title>
    <g>
        <polyline points="13.86 9.95 10.94 12.87 8.02 9.95" fill="none" stroke="#0f3c5f" stroke-miterlimit="10"/>
        <circle cx="10.94" cy="10.94" r="10.44" fill="none" stroke="#0f3c5f" stroke-miterlimit="10"/>
    </g>
</svg>';
            }

            $attributes = '';
            foreach ($atts as $attr => $value) {
                if (!empty($value)) {
                    $value = esc_attr($value);
                    $attributes .= ' ' . $attr . '="' . $value . '"';
                }
            }

            $output .= $indent . sprintf(
                            '<li class="%s"><a%s>%s%s%s%s</a>', $css_classes, $attributes, $args['link_before'],
                            /** This filter is documented in wp-includes/post-template.php */ apply_filters('the_title', $page->post_title, $page->ID), $navMore, $args['link_after']
            );

            if (!empty($args['show_date'])) {
                if ('modified' == $args['show_date']) {
                    $time = $page->post_modified;
                } else {
                    $time = $page->post_date;
                }

                $date_format = empty($args['date_format']) ? '' : $args['date_format'];
                $output .= " " . mysql2date($date_format, $time);
            }
        }

    }

}
    /**
     * Les 100 pièges de l'anglais - FIN
     */
