<?php
/**
 * The template for displaying Archive pages.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package presscore
 * @since presscore 0.1
 */
// File Security Check
if (!defined('ABSPATH')) {
    exit;
}

//$config = Presscore_Config::get_instance();
//$config->base_init();

get_header();
?>

<!-- Content -->
<div id="content" class="content" role="main">

    <div class="container-fluid">
        <div class="row">
            <div class="col-xs-12 col-sm-8 col-sm-offset-2">
                <header>
                    <img src="<?php echo get_stylesheet_directory_uri(); ?>/images/pieges-100/logo-100-pieges.svg" class="img-responsive" alt="Les 100 pièges de l'anglais" />
                </header>
            </div>
            <div class="col-xs-12 col-sm-8 col-sm-offset-2">
                <main>
                    <?php the_field('pieges_texte_daccueill', 11759); ?>
                </main>
            </div>
            <?php
            $savoir = get_field('pieges_lien_en_savoir_pluss', 11759);
            $commencer = get_field('pieges_lien_commencerr', 11759);
            if ($savoir || $commencer) {
                ?>
                <div class="col-xs-12 col-sm-8 col-sm-offset-2">
                    <footer>
                        <?php if ($savoir != '') { ?>
                            <a href="<?php echo $savoir; ?>" class="button white no-chevron"><?php _e('en savoir plus', LANGUAGE_ZONE) ?></a>
                        <?php } ?>
                        <?php if ($savoir && $commencer) { ?>
                            <div class="visible-xs padding-top-mobile"></div>
                        <?php } ?>
                        <?php if ($commencer != '') { ?>
                            <a href="<?php echo $commencer; ?>" class="button"><?php _e('Commencer', LANGUAGE_ZONE) ?></a>
                        <?php } ?>
                    </footer>
                </div>
            <?php } ?>
        </div>
    </div>

</div><!-- #content -->

<?php
get_footer();
