<?php
$prefix = 'fauxami';
?>
<div class="arrow_box2">
    <section class="row bloc-piege bloc-<?php echo $prefix; ?> text-center">
        <div class="col-xs-12">
            <header data-toggle="collapse" data-target="#collapse-<?php echo $prefix; ?>">
                <?php echo apply_filters('wysiwyg_the_content', get_field($prefix . "_titre_du_bloc")); ?>
            </header>
            <main id="collapse-<?php echo $prefix; ?>" class="collapse">
                <?php if (get_field($prefix . "_les_mots")) { ?>
                    <div class="les-mots">
                        <?php echo apply_filters('wysiwyg_the_content', get_field($prefix . "_les_mots")); ?>
                    </div>
                <?php } ?>
                <?php echo get_field($prefix . "_explication_1") ? apply_filters('wysiwyg_the_content', get_field($prefix . "_explication_1")) : ''; ?>
                <?php if (get_field($prefix . "_anglais_francais")) { ?>
                    <div class="anglais-francais">
                        <div class="title">
                            <span>ANGLAIS</span>
                            <img src="<?php echo get_stylesheet_directory_uri(); ?>/images/pieges-100/arrow.svg" alt="fleche" />
                            <span class="color-green">FRAN&Ccedil;AIS</span>
                        </div>
                        <div class="regles">
                            <?php foreach (get_field($prefix . "_anglais_francais") as $regle) { ?>
                                <div class="regle">
                                    <span class="en"><?php echo $regle[$prefix . '_anglais'] ?></span>
                                    <span>
                                        <img src="<?php echo get_stylesheet_directory_uri(); ?>/images/pieges-100/arrow-small.svg" alt="fleche" />
                                    </span>
                                    <span class="fr"><?php echo $regle[$prefix . '_francais'] ?></span>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                <?php } ?>
                <?php echo get_field($prefix . "_explication_2") ? apply_filters('wysiwyg_the_content', get_field($prefix . "_explication_2")) : ''; ?>
            </main>
        </div>
    </section>
</div>